<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Granth')); ?></title>

    <!-- Fonts -->
    
    <link href="<?php echo e(asset('css/all.min.css')); ?>" rel="stylesheet">

    <!-- Styles -->
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('plugin/snackbar/css/snackbar.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/custom.css')); ?>" rel="stylesheet">
    <style>
        .login_bg{
            background-image: url("<?php echo e(asset('/assets/img/bg/login_bg_new1.png')); ?>");
            background-repeat: no-repeat;
        }
    </style>

</head>
<body class="login_bg">
<div id="app">
    <div class="main-content">
        <!-- Navbar -->
        <nav class="navbar navbar-top navbar-horizontal navbar-expand-md navbar-dark">
            <div class="container px-4">
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbar-collapse-main" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbar-collapse-main">
                    <!-- Collapse header -->
                    <div class="navbar-collapse-header d-md-none">
                        <div class="row">
                            <div class="col-6 collapse-brand">
                                <a href="#">
                                    <img src="<?php echo e(asset('assets/img/brand/blue.png')); ?>">
                                </a>
                            </div>
                            <div class="col-6 collapse-close">
                                <button type="button" class="navbar-toggler" data-toggle="collapse" data-target="#navbar-collapse-main" aria-controls="sidenav-main" aria-expanded="false" aria-label="Toggle sidenav">
                                    <span></span>
                                    <span></span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Header -->






        <!-- Page content -->
        <div class="container mt-8 pb-5">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="<?php echo e(asset('js/app.js')); ?>"></script>
<script src="<?php echo e(asset('plugin/snackbar/js/snackbar.js')); ?>"></script>
<script src="<?php echo e(asset('js/custom.js')); ?>"></script>
<script>
    $(document).ready(function () {
        var message="<?php echo e(\Session::get('success')); ?>";
        if(message!=''){
            successMessage(message);
        }
    });
</script>
</body>
</html>
<?php /**PATH /home/gmits-rinkul/Downloads/well-known/resources/views/layouts/app.blade.php ENDPATH**/ ?>